# "Causal Relationship": {
#     "Preceding Events": [],
#     "Subsequent Events": ["Event 2"]
# }

# 注：生成时用的编号不带Act x（因为是一幕一幕地来，这样能减少信息干扰），但生成结束后用脚本把它加上(也就是变成Act x-Event y。在plot_lines.json文件中能看到实际保存格式)
plotline_format = {
    "Basic Content": {
        "Main Content": "Description of the main content of this Act",
        "Theme": "Description of the theme of this Act",
        "Characters List": ["Character A", "Character B", "Character C"],
        "Main Characters List": ["Character A"],
        "Minor Characters List": ["Character B", "Character C"]
    },
    "Plot Chains List": [
        {
            "Event ID": "Event 1",
            "Diegesis": "Slow-Pace Narration",
            "Description": "Character A receives a mission from Character B.",
            "Place and Time": "The place and time of Event 1.",
            "Background": "Background information of Event 1.",
            "Detailed": "Detailed explanation of Event 1.",
            "End Suspense": "The suspense left by Event 1.",
            "Associated Characters": ["Character A", "Character B"]
        },
        {
            "Event ID": "Event 2",
            "Diegesis": "Fast-Pace Narration",
            "Description": "Character A meets Character C and helps Character C during the mission.",
            "Place and Time": "The place and time of Event 2.",
            "Background": "Background information of Event 2.",
            "Detailed": "Detailed explanation of Event 2.",
            "End Suspense": "The suspense left by Event 2.",
            "Associated Characters": ["Character A", "Character C"]
        },
        {
            "Event ID": "Event 3",
            "Diegesis": "Turning Point",
            "Description": "Character A encounters obstacles during the mission.",
            "Place and Time": "The place and time of Event 3.",
            "Background": "Background information of Event 3.",
            "Detailed": "Detailed explanation of Event 3.",
            "End Suspense": "None.",
            "Associated Characters": ["Character A"]
        },
        {
            "Event ID": "Event 4",
            "Diegesis": "Flashback",
            "Description": "Character A recalls what character B had said to her before leaving.",
            "Place and Time": "The place and time of Event 4.",
            "Background": "Background information of Event 4.",
            "Detailed": "Detailed explanation of Event 4.",
            "End Suspense": "The suspense left by Event 4.",
            "Associated Characters": ["Character A", "Character B"]
        },
        {
            "Event ID": "Event 5",
            "Diegesis": "Fast-Pace Narration",
            "Description": "Character A completes the misson.",
            "Place and Time": "The place and time of Event 5.",
            "Background": "Background information of Event 5.",
            "Detailed": "Detailed explanation of Event 5.",
            "End Suspense": "None.",
            "Associated Characters": ["Character A"]
        }
    ],
    "Main Plots List": [
        "Event 1",
        "Event 2",
        "Event 4",
        "Event 5"
    ],
    "Minor Plots List": [
        "Event 3"
    ]
}

profile_format = {
    "Character Relationships": {
        "Character A": {
            "Character B": "Relationship between Character A and Character B",
            "Character C": "Relationship between Character A and Character C"
        },
        "Character B": {
            "Character A": "Relationship between Character B and Character A",
        }
    },
    "Character Biographies": {
        "Character A": [
            {
                "Event ID": "Event 1",
                "Monologue": "The monologue of the character A about Event 1",
                "Changes": "Psychology and desires changes of Character A in Event 1"
            },
            {
                "Event ID": "Event 2",
                "Monologue": "The monologue of the character A about Event 2",
                "Changes": "Psychology and desires changes of Character A in Event 2"
            }
        ],
        "Character B": [
            {
                "Event ID": "Event 1",
                "Monologue": "The monologue of the character B about Event 1",
                "Changes": "Psuychology and desires changes of Character B in Event 1"
            },
            {
                "Event ID": "Event 4",
                "Monologue": "The monologue of the character B about Event 4",
                "Changes": "Psychology and desires changes of Character B in Event 4"
            }
        ]
    }
}

from .utils import CodeParser
import json
def extract_JSON(response):
    return json.loads(CodeParser.parse_code(block=None, text=response, lang="json").strip())

def extract_TXT(response):
    try:
        result: str = CodeParser.parse_code(block=None, text=response, lang="txt").strip()
    except:
        result = None
    return result

def extract_plotline(response):
    try: act = extract_JSON(response)
    except: act = {}
    return act

def extract_profile(response):
    try: profile = extract_JSON(response)
    except: profile = {}
    return profile


# ISSUE 2:
# - LOCATION: [Act 4]
# - TYPE: [CAUSAL]
# - SEVERITY: [MEDIUM]
# - ERROR: [The causal relationship between Act 4-Event 2 and Act 4-Event 5 is missed.]
# - SUGGESTION: [Act 4-Event 2 should be the preceding event of Act 4-Event 5, and Act 4-Event 5 should be the subsequent event of Act 4-Event 2.]

refine_format1 = """### Issues about Plot Lines:
ISSUE 1:
- LOCATION: [Which act does this issue occur in. e.g. Act 2]
- TYPE: [Type of this issue, e.g. EVENTS, CHARACTER PRIORITY, PLOTS PRIORITY, DETAILS.]
- SEVERITY: [Severity of this issue, e.g. HIGH, MEDIUM, LOW]
- ERROR: [Description of error or inconsistency about this issue.]
- SUGGESTION: [Detailed suggested modification about this issue.]
ISSUE 2:
- LOCATION: [Act 4]
- TYPE: [DIEGESIS]
- SEVERITY: [MEDIUM]
- ERROR: [The Act 4-Event 3 shoule be Flashback, not Slow-Pace Narration.]
- SUGGESTION: [Revise the Diegesis of Act 4-Event3 to Flashback.]
ISSUE 3:
- LOCATION: [Act 2]
- TYPE: [CHARACTER PRIORITY]
- SEVERITY: [LOW]
- ERROR: [The Character B's behavior in Act 2 has little impact on the overall story.]
- SUGGESTION: [Consider relegating her into the Minor Characters List.]
...
"""

refine_format2 = """### Issues about Character Profiles:
ISSUE 1:
- LOCATION: [Which act does this issue occur in. e.g. Act 5]
- TYPE: [Type of this issue, e.g. RELATIONSHIP, EVENTS, MONOLOGUE, CHANGES, etc.]
- SEVERITY: [Severity of this issue, e.g. HIGH, MEDIUM, LOW]
- ERROR: [Description of error or inconsistency about this issue.]
- SUGGESTION: [Detailed suggested modification about this issue.]
ISSUE 2:
- LOCATION: [Act 5]
- TYPE: [MONOLOGUE]
- SEVERITY: [MEDIUM]
- ERROR: [Character D's monologue for Act x-Event y doesn't fit him.]
- SUGGESTION: [How to modify Character D's monologue, make it more more suitable for his character.]
ISSUE 3:
- LOCATION: [Act 2]
- TYPE: [RELATIONSHIP]
- SEVERITY: [LOW]
- ERROR: [There is a lack of relationship for Characer B, Character A's mother.]
- SUGGESTION: [Complete the relationship between role A and role B. Character B should be the mother of Character A, who played a crucial part in his early life.]
...
"""

import re
def extract_refine(response):
    refinements = []
    if "No errors or inconsistencies found" in response: return []
    response = response.strip()+'\n' #末尾再加个'\n'防止最后一个pattern读不到
    pattern = re.compile(r'- LOCATION: (.+?)\n- TYPE: (.+?)\n- SEVERITY: (.+?)\n- ERROR: (.+?)\n- SUGGESTION: (.+?)\n')
    matches = pattern.findall(response)
    for match in matches:
        location,Type,severity,error,suggestion = match
        if location and Type and severity and error and suggestion:
            if Type.startswith('[') and Type.endswith(']'): Type = Type[1:-1]
            if error.startswith('[') and error.endswith(']'): error = error[1:-1]
            if location.startswith('[') and location.endswith(']'): location = location[1:-1]
            if severity.startswith('[') and severity.endswith(']'): severity = severity[1:-1]
            if suggestion.startswith('[') and suggestion.endswith(']'): suggestion = suggestion[1:-1]
            location=location.replace(".","").strip()
            Type = Type.strip()
            severity = severity.strip()
            error = error.strip()
            suggestion = suggestion.strip()
            if location and Type and severity and error and suggestion:
                refinements.append({'location': location,'type':Type,'severity':severity,'error': error,'suggestion': suggestion})
    return refinements

def get_history_refinements(all_refinements): #获取修改建议历史
    history = ""
    for i,refine in enumerate(all_refinements):
        history += f"ISSUE {i+1}:\n- LOCATION: [{refine['location']}]\n- TYPE: [{refine['type']}]\n- SEVERITY: [{refine['severity']}]\n- ERROR: [{refine['error']}]\n- SUGGESTION: [{refine['suggestion']}]\n"
    return history

def refinements_sort(refinements): #修改建议按照严重程度排序
    high,medium,low,other = [],[],[],[]
    for i,refine in enumerate(refinements):
        if "HIGH" in refine['severity']: high.append(refine)
        elif "MEDIUM" in refine['severity']: medium.append(refine)
        elif "LOW" in refine['severity']: low.append(refine)
        else: other.append(refine)
    return high+medium+low+other,f"high {len(high)} medium {len(medium)} low {len(low)} other {len(other)}"

improve_format1 = """### Revised Plot Line:
```json
[Here is your revised plot line.]
```"""

improve_format2 = """### Revised Character Profile:
```json
[Here is your revised character profile.]
```"""

def extract_improve_(response,labels=[]):
    try:
        for label in labels:
            text = f"Revised {label}"
            response = response.replace(f'{text} :',text).strip()
            response = response.replace(f'{text}:',text).strip()
            response = response.replace(f'### {text}',text).strip()
            if response.startswith(text): response = response.replace(text,'').strip()
        improvement = extract_JSON(response)
    except: improvement = {}
    return improvement

def extract_improve(response):
    return extract_improve_(response,['Plot Line','Character Profile'])

dag_format = """### Causal Relationships of the Plot Lines:
RELATIONSHIP 1:
- Events: Act 1-Event 1 -> Act 1-Event 2
- Strength: [The strength of the causal relationship, e.g. HIGH, MEDIUM, LOW ]
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 2:
- Events: Act 1-Event 2 -> Act 1-Event 3
- Strength: MEDIUM
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 3:
- Events: Act 1-Event 2 -> Act 1-Event 5
- Strength: HIGH
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 4:
- Events: Act 1-Event 3 -> Act 1-Event 4
- Strength: MEDIUM
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 5:
- Events: Act 1-Event 3 -> Act 2-Event 4
- Strength: MEDIUM
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 6:
- Events: Act 1-Event 4 -> Act 1-Event 5
- Strength: MEDIUM
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 7:
- Events: Act 1-Event 5 -> Act 2-Event 1
- Strength: LOW
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 8:
- Events: Act 2-Event 1 -> Act 2-Event 2
- Strength: MEDIUM
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 9:
- Events: Act 2-Event 2 -> Act 2-Event 3
- Strength: HIGH
- Details: [Here is the detailed relationship of this tow events.]
RELATIONSHIP 10:
- Events: Act 2-Event 3 -> Act 2-Event 4
- Strength: HIGH
- Details: [Here is the detailed relationship of this tow events.]
"""

def extract_DAG(response):
    edges = []
    response = response.strip()+'\n' #末尾再加个'\n'防止最后一个pattern读不到
    pattern = re.compile(r'- Events: Act (.+?)-Event (.+?) -> Act (.+?)-Event (.+?)\n- Strength: (.+?)\n- Details: (.+?)\n')
    matches = pattern.findall(response)
    for match in matches:
        a,b,c,d,strength,detail = match
        if a and b and c and d and strength and detail:
            if strength.startswith('[') and strength.endswith(']'): strength = strength[1:-1]
            if detail.startswith('[') and detail.endswith(']'): detail = detail[1:-1]
            edge = [f"Act {a}-Event {b}",f"Act {c}-Event {d}",strength,detail]
            edges.append(edge)
    edges = edges
    return edges


outline_format = {
    "Story Core Elements": {
        "Title" : "The adapted screenplay's title.",
        "Theme": "Story's central theme or message.",
        "Core Conflict": "Description of the central conflict in the story.",
        "Climax": "Description of the climax in the story.",
        "Resolution": "How the story resolves."
    },
    "Main Characters List": [
        "Character A",
        "Character B",
        "Character C"
    ],
    "Key Events List": [
        "Event 1",
        "Event 3",
        "Event 4",
        "Event 7",
        "Event 9"
    ],
    "Minor Events List": [
        "Event 2",
        "Event 5",
        "Event 6",
        "Event 8"
    ],
    "Screenplay Structure": "e.g. Three-Act Structure, Freytag’s Pyramid, Hero’s Journey, Four-Act Structure.",
    "Structure Reason": "Why choose this structure. e.g. This is the provided structure setting.",
    "Adapted Acts List": [
        {
            "Act ID": "Act 1",
            "Scenes List": [
                {
                    "Scene ID": "Act 1-Scene 1",
                    "Place and Time": "The place and time of this Scene.",
                    "Background": "Background information of this Scene.",
                    "Storyline": "Brief description of this scene's plots",
                    "Storyline Goal": "Brief description of this scene's goal.",
                    "Character Experiences": "Description of characters' emotional changes and experiences.",
                    "End Suspense": "The suspense left by this Scene.",
                    "Associated Events List": [
                        "Event 1",
                        "Event 2",
                        "Event 3"
                    ]
                },
                {
                    "Scene ID": "Act 1-Scene 2",
                    "Place and Time": "The place and time of this Scene.",
                    "Background": "Background information of this Scene.",
                    "Storyline": "Brief description of this scene's plots",
                    "Storyline Goal": "Brief description of this scene's goal.",
                    "Character Experiences": "Description of characters' emotional changes and experiences.",
                    "End Suspense": "None.",
                    "Associated Events List": [
                        "Event 4",
                        "Event 5",
                        "Event 6"
                    ]
                }
            ],
            "Turning Points List": [
                {
                    "Scene ID": "Act 1-Scene 2",
                    "Reason": "The reason why Act 1-Scene 2 is a turning point."
                }
            ]
        },
        {
            "Act ID": "Act 2",
            "Scenes List": [
                {
                    "Scene ID": "Act 2-Scene 1",
                    "Place and Time": "The place and time of this Scene.",
                    "Background": "Background information of this Scene.",
                    "Storyline": "Brief description of this scene's plots",
                    "Storyline Goal": "Brief description of this scene's goal.",
                    "Character Experiences": "Description of characters' emotional changes and experiences.",
                    "End Suspense": "None.",
                    "Associated Events List": [
                        "Event 7",
                        "Event 8",
                        "Event 9"
                    ]
                }
            ],
            "Turning Points List": [
                {
                    "Scene ID": "Act 2-Scene 1",
                    "Reason": "The reason why Act 2-Scene 1 is a turning point."
                }
            ]
        }
    ]
}

def extract_outline(response):
    try: acts = extract_JSON(response)
    except: acts = {}
    return acts

script_format = """INT. LUXURY HOTEL ROOM - NIGHT 
On the screen, ANNA SMITH (a beautiful 23-year-old woman) 
passionately kissing RICHARD ANDERSON (a 29-year-old man) in a dimly lit hotel room. They're on the bed. Richard responds eagerly to Anna's kiss, he undresses her, and soon both of their clothes are scattered on the floor. They engage in intimacy.
CUT TO: 
INT. LUXURY HOTEL ROOM - DAY 
The next day, Richard and Anna wrapped in a blanket. Richard hugs Anna from behind. Anna slowly opens her eyes, looking like she just woke up. She smiles happily. 
ANNA 
I'm glad I could give my first night to you, Ryan. 
Richard, behind her, kisses Anna's ear. 
RICHARD 
I'm glad if you're happy, Tiffany. 
Hearing the man behind her mention another woman's name, Anna quickly opens her eyes. She immediately gets out of bed and opens the hotel room curtains. The room brightens. 
ANNA 
(surprised) 
You're not Ryan! 
Richard is only wearing shorts, his body exposed. He rubs his eyes, the room brightened, he can see the woman in front of him is not TIFFANY (a 25-year-old woman, his girlfriend). 
RICHARD 
(still half asleep) 
Who are you! You're not Tiffany! 
ANNA 
This is room number 316. I'm not mistaken. This is my fiancé Ryan's room. 
Richard laughs. He quickly stands up and walks to grab a 
cigarette. 
RICHARD 
Just tell me how much money you want, then you have to leave immediately. 
SOUND EFFECT: Ding dong... Ding dong... 
The sound of the hotel room doorbell is heard. 
Anna quickly searches for her clothes and puts them on 
hurriedly.
ANNA 
That must be Ryan! He's looking for me. 
Anna puts on her clothes in a hurry. 
After putting on her clothes, Anna quickly grabs her bag and puts on her shoes, then rushes to open the door. 
ANNA 
Ryan! 
The door opens, revealing a laundry attendant. 
LAUNDRY ATTENDANT 
(smiling) 
Good morning, I have brought the clothes for Mr. Anderson. 
Anna looks at the man with disappointment. 
Richard stands beside Anna and takes the clothes from the 
server. 
RICHARD 
Thank you. 
LAUNDRY ATTENDANT 
You're welcome, Mr. Anderson. 
The laundry attendant leaves the room. Anna is still standing in place. Richard leaves her alone. He enters the room and writes a check. 
After writing the check, he returns to Anna and hands her the check. 
RICHARD 
Take this and go.	
"""

def extract_script(response):
    response = response.replace("```plaintxt","```txt").replace("```plaintext","```txt")
    try: script = extract_TXT(response)
    except: script = {}
    return script

refine_format3 = """### Issues about Outlines:
ISSUE 1:
- LOCATION: [Which scene does this issue occur in. e.g. Act 5-Scene 4.]
- TYPE: [Type of this issue, e.g. SCENES, CHARACTER, EVENTS.]
- SEVERITY: [Severity of this issue, e.g. HIGH, MEDIUM, LOW]
- ERROR: [Description of error or inconsistency about this issue.]
- SUGGESTION: [Detailed suggested modification about this issue.]
ISSUE 2:
- LOCATION: [Act 5-Scene 1]
- TYPE: [SCENES]
- SEVERITY: [MEDIUM]
- ERROR: [Act 5-Scene 1 is adapted from Event 2. Event 2 is a minor point, should be abbreviated.]
- SUGGESTION: [How to abbreviate this scene or merge it with another scene.]
ISSUE 3:
- LOCATION: [Act 2-Scene 2]
- TYPE: [EVENTS]
- SEVERITY: [HIGH]
- ERROR: [Act 2-Scene 2 is adapted from Event 8. Event 8 should be a minor point, but it's in the Key Events List.]
- SUGGESTION: [Remove this event from the Key Events List and abbreviate this scene.]
...
"""

refine_format4 = """### Issues about Scripts:
ISSUE 1:
- LOCATION: [Which scene does this issue occur in. e.g. Act 5-Scene 4.]
- TYPE: [Type of this issue, e.g. STORYLINE, GOAL, TRANSITION, CHARACTER, FORMAT.]
- SEVERITY: [Severity of this issue, e.g. HIGH, MEDIUM, LOW]
- ERROR: [Description of error or inconsistency about this issue.]
- SUGGESTION: [Detailed suggested modification about this issue.]
ISSUE 2:
- LOCATION: [Act 5-Scene 1]
- TYPE: [GOAL]
- SEVERITY: [HIGH]
- ERROR: [This script did not achieve the storyline goal.]
- SUGGESTION: [How to revise the script of this scene.]
ISSUE 3:
- LOCATION: [Act 2-Scene 2]
- TYPE: [CHARACTER]
- SEVERITY: [MEDIUM]
- ERROR: [Character A should be the son of character B and should be spoken to respectfully.]
- SUGGESTION: [How to revise the dialogues in script of this scene.]
...
"""

def extract_refine34(response):
    return extract_refine(response)

improve_format3 = """### Revised Outline:
```json
[Here is your revised outline.]
```"""

improve_format4 = script_format

def extract_improve3(response):
    return extract_improve_(response,'Outline')